Set oServer = CreateObject("CDOEXM.ExchangeServer")
Set oFirstStorageGroup = CreateObject("CDOEXM.StorageGroup")
Set oMailboxStoreDB = CreateObject("CDOEXM.MailBoxStoreDB")
Set oPublicStoreDB = CreateObject("CDOEXM.PublicStoreDB")

'Set up Params
	if WScript.Arguments.Count = 4 then
		strServer = WScript.Arguments(0)
		strStorageGroup = WScript.Arguments(1)
		strMDB = WScript.Arguments(2)
   
		if WScript.Arguments(3) = "Mount" then
			bMount = true
		elseif WScript.Arguments(3) = "Dismount" then
			bMount = false
		else
			WScript.echo "4th pararmeter must be either Mount or Dismount"
		end if
	else
		WScript.echo "Usage Error, must enter 4 parameters"	
		Call Usage
		WScript.quit
	end if

	'Open up the server
	oServer.DataSource.Open (strServer)

	'Get an array of StorageGroup objects
	oStorageGroups = oServer.StorageGroups

	'Get the count of SGs
	cSGs = UBound(oStorageGroups) - LBound(oStorageGroups)

	'Go through the SGs and look for the Storage group the user wants
	bFound = false
	for iSGs = 0 to cSGs
		oFirstStorageGroup.DataSource.Open (oStorageGroups(iSGs))
		if oFirstStorageGroup.Name = strStorageGroup then
			bFound = true
			exit for
    		end if
	next
	if not bFound then
		WScript.echo "Storage group not found"
		WScript.quit
	end if

	'Get an array of MBX DBs
	oDBs = oFirstStorageGroup.MailboxStoreDBs

	'Get count of DBs
	cDBs = UBound(oDBs) - LBound(oDBs)

	'Go through the MBX DBs and look for the one the user wants to dis/mount
	bFound = false
	for iDBs = 0 to cDBs
		oMailboxStoreDB.DataSource.Open (oDBs(iDBs))
		if oMailboxStoreDB.Name = strMDB then
			bFound = true
			exit for
    		end if
    	next

	'If we found the DB the user wants to Mount/Dismount
	'If not found try the PF DBs
	if bFound then
		if bMount then
			oMailboxStoreDB.Mount
			strActionDone = "Mounted"
		else
			oMailboxStoreDB.Dismount
			strActionDone = "Dismounted"
		end if
		WScript.echo oFirstStorageGroup.Name +  " - " + oMailboxStoreDB.Name + " " + strActionDone		
	else
		'Get an array of PF DBs
		oDBs = oFirstStorageGroup.PublicStoreDBs

		'Get count of DBs
		cDBs = UBound(oDBs) - LBound(oDBs)
		
		'Go through the PF DBs and look for the one the user wants to dis/mount
		for iDBs = 0 to cDBs
			oPublicStoreDB.DataSource.Open (oDBs(iDb))
			if oPublicStoreDB.Name = strMDB then
				bFound = true
				exit for
			end if
    		next
		if bFound then
			if bMount then
				oPublicStoreDB.Mount
				strActionDone = "Mounted"
			else
				oPublicStoreDB.Dismount
				strActionDone = "Dismounted"
			end if
			WScript.echo oFirstStorageGroup.Name +  " - " + oPublicStoreDB.Name + " " + strActionDone
		else
			WScript.echo "The DB was not found in the Storage group"
		end if
	end if

sub Usage
	Wscript.echo "Usage: Mount <Server> <Storage Group> <MDB> <Mount or Dismount>"
	Wscript.echo "Usage: The parameters are case sensitive"
	Wscript.echo "Usage: Parameters with a space must be enclosed in double quotes."
End sub
